// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : POSITION;
    float4 Color	  : COLOR0;
    float2 Texture0   : TEXCOORD0;
    //float2 Texture1   : TEXCOORD1;
};


// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};


// Global variables
sampler2D Tex0;
sampler2D Tex1;
float4 Params;

PS_OUTPUT ps_main( in PS_INPUT In )
{
    PS_OUTPUT Out;                             //create an output pixel		
    float4 aColor1 = tex2D(Tex0, In.Texture0 + float2(Params[1], Params[2]));
    float4 aColor2 = tex2D(Tex0, In.Texture0 + float2(Params[2], Params[1]));
    float4 aColor3 = tex2D(Tex0, In.Texture0 + float2(Params[3], Params[1]));
    float4 aColor4 = tex2D(Tex0, In.Texture0 + float2(Params[2], Params[3]));
    float4 aColorA = lerp(aColor1, aColor2, 0.5);
    float4 aColorB = lerp(aColor3, aColor4, 0.5);
    float4 aColor = lerp(aColorA, aColorB, 0.5);        
    Out.Color = aColor;
    return Out;                                //return output pixel
}

technique Default
{
	pass P0
	{
		PixelShader = compile ps_2_0 ps_main();
	}
}
